/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook;

import be.maximvdw.tabcore.facebook.RawAPIResponse;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import java.io.Serializable;

final class RawAPIResponseImpl
implements RawAPIResponse,
Serializable {
    private static final long serialVersionUID = 8389958738540393505L;
    private final String responseAsString;
    private final JSONObject jsonObject;
    private final JSONArray jsonArray;
    private final Boolean bool;

    RawAPIResponseImpl(HttpResponse httpResponse) {
        this.responseAsString = httpResponse.asString();
        if (this.responseAsString.startsWith("{")) {
            this.jsonObject = httpResponse.asJSONObject();
            this.jsonArray = null;
            this.bool = null;
        } else if (this.responseAsString.startsWith("[")) {
            this.jsonObject = null;
            this.jsonArray = httpResponse.asJSONArray();
            this.bool = null;
        } else {
            this.jsonObject = null;
            this.jsonArray = null;
            this.bool = Boolean.valueOf(this.responseAsString.trim());
        }
    }

    public boolean isJSONObject() {
        return this.jsonObject != null;
    }

    public boolean isJSONArray() {
        return this.jsonArray != null;
    }

    public boolean isBoolean() {
        return this.bool != null;
    }

    public JSONObject asJSONObject() {
        return this.jsonObject;
    }

    public JSONArray asJSONArray() {
        return this.jsonArray;
    }

    public boolean asBoolean() {
        return this.bool;
    }

    public String asString() {
        return this.responseAsString;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RawAPIResponseImpl)) {
            return false;
        }
        RawAPIResponseImpl rawAPIResponseImpl = (RawAPIResponseImpl)object;
        return !(this.responseAsString != null ? !this.responseAsString.equals(rawAPIResponseImpl.responseAsString) : rawAPIResponseImpl.responseAsString != null);
    }

    public int hashCode() {
        return this.responseAsString != null ? this.responseAsString.hashCode() : 0;
    }

    public String toString() {
        return "RawAPIResponseImpl{responseAsString='" + this.responseAsString + '\'' + '}';
    }
}

