/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.conf;

import be.maximvdw.tabcore.facebook.Version;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationBase
implements Configuration,
Serializable {
    private static final long serialVersionUID = -4618524490519309627L;
    private boolean debug;
    private String userAgent;
    private boolean useSSL;
    private boolean prettyDebug;
    private boolean gzipEnabled;
    private String httpProxyHost;
    private String httpProxyUser;
    private String httpProxyPassword;
    private int httpProxyPort;
    private int httpConnectionTimeout;
    private int httpReadTimeout;
    private int httpStreamingReadTimeout;
    private int httpRetryCount;
    private int httpRetryIntervalSeconds;
    private int maxTotalConnections;
    private int defaultMaxPerRoute;
    private String oAuthAppId;
    private String oAuthAppSecret;
    private String oAuthPermissions;
    private String oAuthAccessToken;
    private String oAuthCallbackURL;
    private boolean appSecretProofEnabled;
    private int appSecretProofCacheSize;
    private String oAuthAuthorizationURL;
    private String oAuthAccessTokenURL;
    private String oAuthAccessTokenInfoURL;
    private String oAuthDeviceTokenURL;
    private String restBaseURL;
    private String videoBaseURL;
    private boolean jsonStoreEnabled;
    private boolean mbeanEnabled;
    private String clientVersion;
    private String clientURL;
    public static final String DALVIK = "be.maximvdw.tabcore.facebook.dalvik";
    public static final String GAE = "be.maximvdw.tabcore.facebook.gae";
    private static final String DEFAULT_OAUTH_AUTHORIZATION_URL = "http://www.facebook.com/dialog/oauth";
    private static final String DEFAULT_OAUTH_ACCESS_TOKEN_URL = "http://graph.facebook.com/oauth/access_token";
    private static final String DEFAULT_OAUTH_ACCESS_TOKEN_INFO_URL = "http://graph.facebook.com/oauth/access_token_info";
    private static final String DEFAULT_OAUTH_DEVICE_TOKEN_URL = "http://graph.facebook.com/oauth/device";
    private static final String DEFAULT_REST_BASE_URL = "http://graph.facebook.com/";
    private static final String DEFAULT_VIDEO_BASE_URL = "http://graph-video.facebook.com/";
    private boolean IS_DALVIK;
    private boolean IS_GAE;
    static String dalvikDetected;
    static String gaeDetected;
    Map<String, String> requestHeaders;
    private static final List<ConfigurationBase> instances;

    protected ConfigurationBase() {
        String string;
        String string2;
        this.setDebug(false);
        this.setUseSSL(true);
        this.setPrettyDebugEnabled(false);
        this.setGZIPEnabled(true);
        this.setHttpProxyHost(null);
        this.setHttpProxyUser(null);
        this.setHttpProxyPassword(null);
        this.setHttpProxyPort(-1);
        this.setHttpConnectionTimeout(20000);
        this.setHttpReadTimeout(120000);
        this.setHttpStreamingReadTimeout(40000);
        this.setHttpRetryCount(0);
        this.setHttpRetryIntervalSeconds(5);
        this.setHttpMaxTotalConnections(20);
        this.setHttpDefaultMaxPerRoute(2);
        this.setOAuthAppId(null);
        this.setOAuthAppSecret(null);
        this.setOAuthAccessToken(null);
        this.setOAuthCallbackURL(null);
        this.setAppSecretProofEnabled(false);
        this.setAppSecretProofCacheSize(10);
        this.setClientVersion(Version.getVersion());
        this.setClientURL("http://facebook4j.org/en/facebook4j-" + Version.getVersion() + ".xml");
        this.setUserAgent("be/maximvdw/tabcore/facebook http://facebook4j.org/ /" + Version.getVersion());
        this.setJSONStoreEnabled(false);
        this.setMBeanEnabled(false);
        this.setOAuthAuthorizationURL(DEFAULT_OAUTH_AUTHORIZATION_URL);
        this.setOAuthAccessTokenURL(DEFAULT_OAUTH_ACCESS_TOKEN_URL);
        this.setOAuthAccessTokenInfoURL(DEFAULT_OAUTH_ACCESS_TOKEN_INFO_URL);
        this.setOAuthDeviceTokenURL(DEFAULT_OAUTH_DEVICE_TOKEN_URL);
        this.setRestBaseURL(DEFAULT_REST_BASE_URL);
        this.setVideoBaseURL(DEFAULT_VIDEO_BASE_URL);
        try {
            string2 = System.getProperty(DALVIK, dalvikDetected);
        }
        catch (SecurityException securityException) {
            string2 = dalvikDetected;
        }
        this.IS_DALVIK = Boolean.valueOf(string2);
        try {
            string = System.getProperty(GAE, gaeDetected);
        }
        catch (SecurityException securityException) {
            string = gaeDetected;
        }
        this.IS_GAE = Boolean.valueOf(string);
    }

    @Override
    public final boolean isDalvik() {
        return this.IS_DALVIK;
    }

    @Override
    public boolean isGAE() {
        return this.IS_GAE;
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.debug;
    }

    protected final void setDebug(boolean bl2) {
        this.debug = bl2;
    }

    @Override
    public final String getUserAgent() {
        return this.userAgent;
    }

    protected final void setUserAgent(String string) {
        this.userAgent = string;
        this.initRequestHeaders();
    }

    @Override
    public boolean isPrettyDebugEnabled() {
        return this.prettyDebug;
    }

    protected final void setUseSSL(boolean bl2) {
        this.useSSL = bl2;
        this.fixRestBaseURL();
    }

    protected final void setPrettyDebugEnabled(boolean bl2) {
        this.prettyDebug = bl2;
    }

    protected final void setGZIPEnabled(boolean bl2) {
        this.gzipEnabled = bl2;
        this.initRequestHeaders();
    }

    @Override
    public boolean isGZIPEnabled() {
        return this.gzipEnabled;
    }

    private void initRequestHeaders() {
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("User-Agent", this.getUserAgent());
        if (this.gzipEnabled) {
            this.requestHeaders.put("Accept-Encoding", "gzip");
        }
        if (this.IS_DALVIK) {
            this.requestHeaders.put("Connection", "close");
        }
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public final String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    protected final void setHttpProxyHost(String string) {
        this.httpProxyHost = string;
    }

    @Override
    public final String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    protected final void setHttpProxyUser(String string) {
        this.httpProxyUser = string;
    }

    @Override
    public final String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    protected final void setHttpProxyPassword(String string) {
        this.httpProxyPassword = string;
    }

    @Override
    public final int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    protected final void setHttpProxyPort(int n2) {
        this.httpProxyPort = n2;
    }

    @Override
    public final int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    protected final void setHttpConnectionTimeout(int n2) {
        this.httpConnectionTimeout = n2;
    }

    @Override
    public final int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    protected final void setHttpReadTimeout(int n2) {
        this.httpReadTimeout = n2;
    }

    public int getHttpStreamingReadTimeout() {
        return this.httpStreamingReadTimeout;
    }

    protected final void setHttpStreamingReadTimeout(int n2) {
        this.httpStreamingReadTimeout = n2;
    }

    @Override
    public final int getHttpRetryCount() {
        return this.httpRetryCount;
    }

    protected final void setHttpRetryCount(int n2) {
        this.httpRetryCount = n2;
    }

    @Override
    public final int getHttpRetryIntervalSeconds() {
        return this.httpRetryIntervalSeconds;
    }

    protected final void setHttpRetryIntervalSeconds(int n2) {
        this.httpRetryIntervalSeconds = n2;
    }

    @Override
    public final int getHttpMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    protected final void setHttpMaxTotalConnections(int n2) {
        this.maxTotalConnections = n2;
    }

    @Override
    public final int getHttpDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    protected final void setHttpDefaultMaxPerRoute(int n2) {
        this.defaultMaxPerRoute = n2;
    }

    @Override
    public final String getOAuthAppId() {
        return this.oAuthAppId;
    }

    protected final void setOAuthAppId(String string) {
        this.oAuthAppId = string;
        this.fixRestBaseURL();
    }

    @Override
    public final String getOAuthAppSecret() {
        return this.oAuthAppSecret;
    }

    protected final void setOAuthAppSecret(String string) {
        this.oAuthAppSecret = string;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAccessToken() {
        return this.oAuthAccessToken;
    }

    protected final void setOAuthAccessToken(String string) {
        this.oAuthAccessToken = string;
    }

    @Override
    public final String getClientVersion() {
        return this.clientVersion;
    }

    protected final void setClientVersion(String string) {
        this.clientVersion = string;
        this.initRequestHeaders();
    }

    @Override
    public final String getClientURL() {
        return this.clientURL;
    }

    protected final void setClientURL(String string) {
        this.clientURL = string;
        this.initRequestHeaders();
    }

    @Override
    public String getRestBaseURL() {
        return this.restBaseURL;
    }

    @Override
    public String getVideoBaseURL() {
        return this.videoBaseURL;
    }

    protected final void setRestBaseURL(String string) {
        this.restBaseURL = string;
        this.fixRestBaseURL();
    }

    private void fixRestBaseURL() {
        if (DEFAULT_REST_BASE_URL.equals(ConfigurationBase.fixURL(false, this.restBaseURL))) {
            this.restBaseURL = ConfigurationBase.fixURL(this.useSSL, this.restBaseURL);
        }
        if (DEFAULT_OAUTH_ACCESS_TOKEN_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAccessTokenURL))) {
            this.oAuthAccessTokenURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAccessTokenURL);
        }
        if (DEFAULT_OAUTH_ACCESS_TOKEN_INFO_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAccessTokenInfoURL))) {
            this.oAuthAccessTokenInfoURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAccessTokenInfoURL);
        }
        if (DEFAULT_OAUTH_DEVICE_TOKEN_URL.equals(ConfigurationBase.fixURL(false, this.oAuthDeviceTokenURL))) {
            this.oAuthDeviceTokenURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthDeviceTokenURL);
        }
        if (DEFAULT_OAUTH_AUTHORIZATION_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAuthorizationURL))) {
            this.oAuthAuthorizationURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAuthorizationURL);
        }
    }

    protected final void setVideoBaseURL(String string) {
        this.videoBaseURL = string;
        this.fixVideoBaseURL();
    }

    private void fixVideoBaseURL() {
        if (DEFAULT_VIDEO_BASE_URL.equals(ConfigurationBase.fixURL(false, this.videoBaseURL))) {
            this.videoBaseURL = ConfigurationBase.fixURL(this.useSSL, this.videoBaseURL);
        }
    }

    @Override
    public String getOAuthAuthorizationURL() {
        return this.oAuthAuthorizationURL;
    }

    protected final void setOAuthAuthorizationURL(String string) {
        this.oAuthAuthorizationURL = string;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAccessTokenURL() {
        return this.oAuthAccessTokenURL;
    }

    protected final void setOAuthAccessTokenURL(String string) {
        this.oAuthAccessTokenURL = string;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAccessTokenInfoURL() {
        return this.oAuthAccessTokenInfoURL;
    }

    protected final void setOAuthAccessTokenInfoURL(String string) {
        this.oAuthAccessTokenInfoURL = string;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthDeviceTokenURL() {
        return this.oAuthDeviceTokenURL;
    }

    protected final void setOAuthDeviceTokenURL(String string) {
        this.oAuthDeviceTokenURL = string;
        this.fixRestBaseURL();
    }

    @Override
    public boolean isJSONStoreEnabled() {
        return this.jsonStoreEnabled;
    }

    protected final void setJSONStoreEnabled(boolean bl2) {
        this.jsonStoreEnabled = bl2;
    }

    @Override
    public boolean isMBeanEnabled() {
        return this.mbeanEnabled;
    }

    protected final void setMBeanEnabled(boolean bl2) {
        this.mbeanEnabled = bl2;
    }

    @Override
    public String getOAuthPermissions() {
        return this.oAuthPermissions;
    }

    protected void setOAuthPermissions(String string) {
        this.oAuthPermissions = string;
    }

    @Override
    public String getOAuthCallbackURL() {
        return this.oAuthCallbackURL;
    }

    public void setOAuthCallbackURL(String string) {
        this.oAuthCallbackURL = string;
    }

    @Override
    public boolean isAppSecretProofEnabled() {
        return this.appSecretProofEnabled;
    }

    public void setAppSecretProofEnabled(boolean bl2) {
        this.appSecretProofEnabled = bl2;
    }

    @Override
    public int getAppSecretProofCacheSize() {
        return this.appSecretProofCacheSize;
    }

    public void setAppSecretProofCacheSize(int n2) {
        this.appSecretProofCacheSize = n2;
    }

    static String fixURL(boolean bl2, String string) {
        if (null == string) {
            return null;
        }
        int n2 = string.indexOf("://");
        if (-1 == n2) {
            throw new IllegalArgumentException("url should contain '://'");
        }
        String string2 = string.substring(n2 + 3);
        if (bl2) {
            return "https://" + string2;
        }
        return "http://" + string2;
    }

    public int hashCode() {
        int n2 = this.debug ? 1 : 0;
        n2 = 31 * n2 + (this.userAgent != null ? this.userAgent.hashCode() : 0);
        n2 = 31 * n2 + (this.useSSL ? 1 : 0);
        n2 = 31 * n2 + (this.prettyDebug ? 1 : 0);
        n2 = 31 * n2 + (this.gzipEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.httpProxyHost != null ? this.httpProxyHost.hashCode() : 0);
        n2 = 31 * n2 + (this.httpProxyUser != null ? this.httpProxyUser.hashCode() : 0);
        n2 = 31 * n2 + (this.httpProxyPassword != null ? this.httpProxyPassword.hashCode() : 0);
        n2 = 31 * n2 + this.httpProxyPort;
        n2 = 31 * n2 + this.httpConnectionTimeout;
        n2 = 31 * n2 + this.httpReadTimeout;
        n2 = 31 * n2 + this.httpStreamingReadTimeout;
        n2 = 31 * n2 + this.httpRetryCount;
        n2 = 31 * n2 + this.httpRetryIntervalSeconds;
        n2 = 31 * n2 + this.maxTotalConnections;
        n2 = 31 * n2 + this.defaultMaxPerRoute;
        n2 = 31 * n2 + (this.oAuthAppId != null ? this.oAuthAppId.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthAppSecret != null ? this.oAuthAppSecret.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthPermissions != null ? this.oAuthPermissions.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthAccessToken != null ? this.oAuthAccessToken.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthCallbackURL != null ? this.oAuthCallbackURL.hashCode() : 0);
        n2 = 31 * n2 + (this.appSecretProofEnabled ? 1 : 0);
        n2 = 31 * n2 + this.appSecretProofCacheSize;
        n2 = 31 * n2 + (this.oAuthAuthorizationURL != null ? this.oAuthAuthorizationURL.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthAccessTokenURL != null ? this.oAuthAccessTokenURL.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthAccessTokenInfoURL != null ? this.oAuthAccessTokenInfoURL.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthDeviceTokenURL != null ? this.oAuthDeviceTokenURL.hashCode() : 0);
        n2 = 31 * n2 + (this.restBaseURL != null ? this.restBaseURL.hashCode() : 0);
        n2 = 31 * n2 + (this.videoBaseURL != null ? this.videoBaseURL.hashCode() : 0);
        n2 = 31 * n2 + (this.jsonStoreEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.mbeanEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.clientVersion != null ? this.clientVersion.hashCode() : 0);
        n2 = 31 * n2 + (this.clientURL != null ? this.clientURL.hashCode() : 0);
        n2 = 31 * n2 + (this.IS_DALVIK ? 1 : 0);
        n2 = 31 * n2 + (this.IS_GAE ? 1 : 0);
        n2 = 31 * n2 + (this.requestHeaders != null ? ((Object)this.requestHeaders).hashCode() : 0);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConfigurationBase)) {
            return false;
        }
        ConfigurationBase configurationBase = (ConfigurationBase)object;
        if (this.IS_DALVIK != configurationBase.IS_DALVIK) {
            return false;
        }
        if (this.IS_GAE != configurationBase.IS_GAE) {
            return false;
        }
        if (this.debug != configurationBase.debug) {
            return false;
        }
        if (this.defaultMaxPerRoute != configurationBase.defaultMaxPerRoute) {
            return false;
        }
        if (this.gzipEnabled != configurationBase.gzipEnabled) {
            return false;
        }
        if (this.httpConnectionTimeout != configurationBase.httpConnectionTimeout) {
            return false;
        }
        if (this.httpProxyPort != configurationBase.httpProxyPort) {
            return false;
        }
        if (this.httpReadTimeout != configurationBase.httpReadTimeout) {
            return false;
        }
        if (this.httpRetryCount != configurationBase.httpRetryCount) {
            return false;
        }
        if (this.httpRetryIntervalSeconds != configurationBase.httpRetryIntervalSeconds) {
            return false;
        }
        if (this.httpStreamingReadTimeout != configurationBase.httpStreamingReadTimeout) {
            return false;
        }
        if (this.jsonStoreEnabled != configurationBase.jsonStoreEnabled) {
            return false;
        }
        if (this.maxTotalConnections != configurationBase.maxTotalConnections) {
            return false;
        }
        if (this.mbeanEnabled != configurationBase.mbeanEnabled) {
            return false;
        }
        if (this.prettyDebug != configurationBase.prettyDebug) {
            return false;
        }
        if (this.useSSL != configurationBase.useSSL) {
            return false;
        }
        if (this.clientURL != null ? !this.clientURL.equals(configurationBase.clientURL) : configurationBase.clientURL != null) {
            return false;
        }
        if (this.clientVersion != null ? !this.clientVersion.equals(configurationBase.clientVersion) : configurationBase.clientVersion != null) {
            return false;
        }
        if (this.httpProxyHost != null ? !this.httpProxyHost.equals(configurationBase.httpProxyHost) : configurationBase.httpProxyHost != null) {
            return false;
        }
        if (this.httpProxyPassword != null ? !this.httpProxyPassword.equals(configurationBase.httpProxyPassword) : configurationBase.httpProxyPassword != null) {
            return false;
        }
        if (this.httpProxyUser != null ? !this.httpProxyUser.equals(configurationBase.httpProxyUser) : configurationBase.httpProxyUser != null) {
            return false;
        }
        if (this.oAuthAccessToken != null ? !this.oAuthAccessToken.equals(configurationBase.oAuthAccessToken) : configurationBase.oAuthAccessToken != null) {
            return false;
        }
        if (this.oAuthAccessTokenURL != null ? !this.oAuthAccessTokenURL.equals(configurationBase.oAuthAccessTokenURL) : configurationBase.oAuthAccessTokenURL != null) {
            return false;
        }
        if (this.oAuthAccessTokenInfoURL != null ? !this.oAuthAccessTokenInfoURL.equals(configurationBase.oAuthAccessTokenInfoURL) : configurationBase.oAuthAccessTokenInfoURL != null) {
            return false;
        }
        if (this.oAuthDeviceTokenURL != null ? !this.oAuthDeviceTokenURL.equals(configurationBase.oAuthDeviceTokenURL) : configurationBase.oAuthDeviceTokenURL != null) {
            return false;
        }
        if (this.oAuthAppId != null ? !this.oAuthAppId.equals(configurationBase.oAuthAppId) : configurationBase.oAuthAppId != null) {
            return false;
        }
        if (this.oAuthAppSecret != null ? !this.oAuthAppSecret.equals(configurationBase.oAuthAppSecret) : configurationBase.oAuthAppSecret != null) {
            return false;
        }
        if (this.oAuthAuthorizationURL != null ? !this.oAuthAuthorizationURL.equals(configurationBase.oAuthAuthorizationURL) : configurationBase.oAuthAuthorizationURL != null) {
            return false;
        }
        if (this.oAuthCallbackURL != null ? !this.oAuthCallbackURL.equals(configurationBase.oAuthCallbackURL) : configurationBase.oAuthCallbackURL != null) {
            return false;
        }
        if (this.appSecretProofEnabled != configurationBase.appSecretProofEnabled) {
            return false;
        }
        if (this.appSecretProofCacheSize != configurationBase.appSecretProofCacheSize) {
            return false;
        }
        if (this.oAuthPermissions != null ? !this.oAuthPermissions.equals(configurationBase.oAuthPermissions) : configurationBase.oAuthPermissions != null) {
            return false;
        }
        if (this.requestHeaders != null ? !((Object)this.requestHeaders).equals(configurationBase.requestHeaders) : configurationBase.requestHeaders != null) {
            return false;
        }
        if (this.restBaseURL != null ? !this.restBaseURL.equals(configurationBase.restBaseURL) : configurationBase.restBaseURL != null) {
            return false;
        }
        if (this.userAgent != null ? !this.userAgent.equals(configurationBase.userAgent) : configurationBase.userAgent != null) {
            return false;
        }
        return !(this.videoBaseURL != null ? !this.videoBaseURL.equals(configurationBase.videoBaseURL) : configurationBase.videoBaseURL != null);
    }

    public String toString() {
        return "ConfigurationBase{debug=" + this.debug + ", userAgent='" + this.userAgent + '\'' + ", useSSL=" + this.useSSL + ", prettyDebug=" + this.prettyDebug + ", gzipEnabled=" + this.gzipEnabled + ", httpProxyHost='" + this.httpProxyHost + '\'' + ", httpProxyUser='" + this.httpProxyUser + '\'' + ", httpProxyPassword='" + this.httpProxyPassword + '\'' + ", httpProxyPort=" + this.httpProxyPort + ", httpConnectionTimeout=" + this.httpConnectionTimeout + ", httpReadTimeout=" + this.httpReadTimeout + ", httpStreamingReadTimeout=" + this.httpStreamingReadTimeout + ", httpRetryCount=" + this.httpRetryCount + ", httpRetryIntervalSeconds=" + this.httpRetryIntervalSeconds + ", maxTotalConnections=" + this.maxTotalConnections + ", defaultMaxPerRoute=" + this.defaultMaxPerRoute + ", oAuthAppId='" + this.oAuthAppId + '\'' + ", oAuthAppSecret='" + this.oAuthAppSecret + '\'' + ", oAuthPermissions='" + this.oAuthPermissions + '\'' + ", oAuthAccessToken='" + this.oAuthAccessToken + '\'' + ", oAuthCallbackURL='" + this.oAuthCallbackURL + '\'' + ", appSecretProofEnabled=" + this.appSecretProofEnabled + ", appSecretProofCacheSize=" + this.appSecretProofCacheSize + ", oAuthAuthorizationURL='" + this.oAuthAuthorizationURL + '\'' + ", oAuthAccessTokenURL='" + this.oAuthAccessTokenURL + '\'' + ", oAuthAccessTokenInfoURL='" + this.oAuthAccessTokenInfoURL + '\'' + ", oAuthDeviceTokenURL='" + this.oAuthDeviceTokenURL + '\'' + ", restBaseURL='" + this.restBaseURL + '\'' + ", videoBaseURL='" + this.videoBaseURL + '\'' + ", jsonStoreEnabled=" + this.jsonStoreEnabled + ", mbeanEnabled=" + this.mbeanEnabled + ", clientVersion='" + this.clientVersion + '\'' + ", clientURL='" + this.clientURL + '\'' + ", IS_DALVIK=" + this.IS_DALVIK + ", IS_GAE=" + this.IS_GAE + ", requestHeaders=" + this.requestHeaders + '}';
    }

    private static void cacheInstance(ConfigurationBase configurationBase) {
        if (!instances.contains(configurationBase)) {
            instances.add(configurationBase);
        }
    }

    protected void cacheInstance() {
        ConfigurationBase.cacheInstance(this);
    }

    private static ConfigurationBase getInstance(ConfigurationBase configurationBase) {
        int n2 = instances.indexOf(configurationBase);
        if (n2 == -1) {
            instances.add(configurationBase);
            return configurationBase;
        }
        return instances.get(n2);
    }

    protected Object readResolve() {
        return ConfigurationBase.getInstance(this);
    }

    static {
        try {
            Class.forName("dalvik.system.VMRuntime");
            dalvikDetected = "true";
        }
        catch (ClassNotFoundException classNotFoundException) {
            dalvikDetected = "false";
        }
        try {
            Class.forName("com.google.appengine.api.urlfetch.URLFetchService");
            gaeDetected = "true";
        }
        catch (ClassNotFoundException classNotFoundException) {
            gaeDetected = "false";
        }
        instances = new ArrayList<ConfigurationBase>();
    }
}

