/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.http;

import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.conf.ConfigurationContext;
import be.maximvdw.tabcore.facebook.internal.http.HttpClient;
import be.maximvdw.tabcore.facebook.internal.http.HttpClientBase;
import be.maximvdw.tabcore.facebook.internal.http.HttpClientConfiguration;
import be.maximvdw.tabcore.facebook.internal.http.HttpParameter;
import be.maximvdw.tabcore.facebook.internal.http.HttpRequest;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponseCode;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponseImpl;
import be.maximvdw.tabcore.facebook.internal.http.RequestMethod;
import be.maximvdw.tabcore.facebook.internal.logging.Logger;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalStringUtil;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpClientImpl
extends HttpClientBase
implements HttpClient,
HttpResponseCode,
Serializable {
    private static final long serialVersionUID = -1349112176863288573L;
    private static final Logger logger = Logger.getLogger(HttpClientImpl.class);
    private static final Map<HttpClientConfiguration, HttpClient> instanceMap;

    public HttpClientImpl() {
        super(ConfigurationContext.getInstance());
    }

    public HttpClientImpl(HttpClientConfiguration httpClientConfiguration) {
        super(httpClientConfiguration);
    }

    public static HttpClient getInstance(HttpClientConfiguration httpClientConfiguration) {
        HttpClient httpClient = instanceMap.get(httpClientConfiguration);
        if (null == httpClient) {
            httpClient = new HttpClientImpl(httpClientConfiguration);
            instanceMap.put(httpClientConfiguration, httpClient);
        }
        return httpClient;
    }

    public HttpResponse get(String string) {
        return this.request(new HttpRequest(RequestMethod.GET, string, null, null, null));
    }

    public HttpResponse post(String string, HttpParameter[] httpParameterArray) {
        return this.request(new HttpRequest(RequestMethod.POST, string, httpParameterArray, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse request(HttpRequest httpRequest) {
        int n2 = this.CONF.getHttpRetryCount() + 1;
        HttpResponse httpResponse = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            block26: {
                int n3 = -1;
                try {
                    OutputStream outputStream = null;
                    try {
                        Object object;
                        Object object2;
                        HttpURLConnection httpURLConnection = this.getConnection(httpRequest.getURL());
                        httpURLConnection.setDoInput(true);
                        this.setHeaders(httpRequest, httpURLConnection);
                        httpURLConnection.setRequestMethod(httpRequest.getMethod().name());
                        if (httpRequest.getMethod() == RequestMethod.POST) {
                            if (HttpParameter.containsFile(httpRequest.getParameters())) {
                                object2 = "----Facebook4J-upload" + System.currentTimeMillis();
                                httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + (String)object2);
                                object2 = "--" + (String)object2;
                                httpURLConnection.setDoOutput(true);
                                outputStream = httpURLConnection.getOutputStream();
                                object = new DataOutputStream(outputStream);
                                for (HttpParameter httpParameter : httpRequest.getParameters()) {
                                    if (httpParameter.isFile()) {
                                        int n4;
                                        this.write((DataOutputStream)object, (String)object2 + "\r\n");
                                        this.write((DataOutputStream)object, "Content-Disposition: form-data; name=\"" + httpParameter.getName() + "\"; filename=\"" + httpParameter.getFile().getName() + "\"\r\n");
                                        this.write((DataOutputStream)object, "Content-Type: " + httpParameter.getContentType() + "\r\n\r\n");
                                        BufferedInputStream bufferedInputStream = new BufferedInputStream(httpParameter.hasFileBody() ? httpParameter.getFileBody() : new FileInputStream(httpParameter.getFile()));
                                        while ((n4 = bufferedInputStream.read()) != -1) {
                                            ((DataOutputStream)object).write(n4);
                                        }
                                        this.write((DataOutputStream)object, "\r\n");
                                        bufferedInputStream.close();
                                        continue;
                                    }
                                    this.write((DataOutputStream)object, (String)object2 + "\r\n");
                                    this.write((DataOutputStream)object, "Content-Disposition: form-data; name=\"" + httpParameter.getName() + "\"\r\n");
                                    this.write((DataOutputStream)object, "Content-Type: text/plain; charset=UTF-8\r\n\r\n");
                                    logger.debug(httpParameter.getValue());
                                    ((FilterOutputStream)object).write(httpParameter.getValue().getBytes("UTF-8"));
                                    this.write((DataOutputStream)object, "\r\n");
                                }
                                this.write((DataOutputStream)object, (String)object2 + "--\r\n");
                                this.write((DataOutputStream)object, "\r\n");
                            } else {
                                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                                object2 = HttpParameter.encodeParameters(httpRequest.getParameters());
                                logger.debug("Post Params: ", (String)object2);
                                object = ((String)object2).getBytes("UTF-8");
                                httpURLConnection.setRequestProperty("Content-Length", Integer.toString(((byte[])object).length));
                                httpURLConnection.setDoOutput(true);
                                outputStream = httpURLConnection.getOutputStream();
                                outputStream.write((byte[])object);
                            }
                            outputStream.flush();
                            outputStream.close();
                        }
                        httpResponse = new HttpResponseImpl(httpURLConnection, this.CONF);
                        n3 = httpURLConnection.getResponseCode();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Response: ");
                            object2 = httpURLConnection.getHeaderFields();
                            object = object2.keySet().iterator();
                            while (object.hasNext()) {
                                HttpParameter[] httpParameterArray = (HttpParameter[])object.next();
                                List list = (List)object2.get(httpParameterArray);
                                for (String string : list) {
                                    if (httpParameterArray != null) {
                                        logger.debug((String)httpParameterArray + ": " + string);
                                        continue;
                                    }
                                    logger.debug(string);
                                }
                            }
                        }
                        if (n3 >= 200 && (n3 == 302 || 300 > n3)) break;
                        if (n3 == 420 || n3 == 400 || n3 < 500 || i2 == this.CONF.getHttpRetryCount()) {
                            throw new FacebookException(httpResponse.asString(), httpResponse);
                        }
                    }
                    finally {
                        try {
                            outputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException iOException) {
                    if (i2 != this.CONF.getHttpRetryCount()) break block26;
                    throw new FacebookException(iOException.getMessage(), iOException, n3);
                }
            }
            try {
                if (logger.isDebugEnabled() && httpResponse != null) {
                    httpResponse.asString();
                }
                logger.debug("Sleeping " + this.CONF.getHttpRetryIntervalSeconds() + " seconds until the next retry.");
                Thread.sleep(this.CONF.getHttpRetryIntervalSeconds() * 1000);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return httpResponse;
    }

    public static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)"will never happen");
        }
    }

    private void setHeaders(HttpRequest httpRequest, HttpURLConnection httpURLConnection) {
        if (logger.isDebugEnabled()) {
            logger.debug("Request: ");
            logger.debug(httpRequest.getMethod().name() + " ", httpRequest.getURL());
        }
        if (httpRequest.getRequestHeaders() != null) {
            for (String string : httpRequest.getRequestHeaders().keySet()) {
                httpURLConnection.addRequestProperty(string, httpRequest.getRequestHeaders().get(string));
                logger.debug(string + ": " + httpRequest.getRequestHeaders().get(string));
            }
        }
    }

    protected HttpURLConnection getConnection(String string) {
        HttpURLConnection httpURLConnection;
        if (this.isProxyConfigured()) {
            if (this.CONF.getHttpProxyUser() != null && !this.CONF.getHttpProxyUser().equals("")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Proxy AuthUser: " + this.CONF.getHttpProxyUser());
                    logger.debug("Proxy AuthPassword: " + z_F4JInternalStringUtil.maskString(this.CONF.getHttpProxyPassword()));
                }
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                            return new PasswordAuthentication(HttpClientImpl.this.CONF.getHttpProxyUser(), HttpClientImpl.this.CONF.getHttpProxyPassword().toCharArray());
                        }
                        return null;
                    }
                });
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.CONF.getHttpProxyHost(), this.CONF.getHttpProxyPort()));
            if (logger.isDebugEnabled()) {
                logger.debug("Opening proxied connection(" + this.CONF.getHttpProxyHost() + ":" + this.CONF.getHttpProxyPort() + ")");
            }
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection(proxy);
        } else {
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        }
        if (this.CONF.getHttpConnectionTimeout() > 0) {
            httpURLConnection.setConnectTimeout(this.CONF.getHttpConnectionTimeout());
        }
        if (this.CONF.getHttpReadTimeout() > 0) {
            httpURLConnection.setReadTimeout(this.CONF.getHttpReadTimeout());
        }
        httpURLConnection.setInstanceFollowRedirects(false);
        return httpURLConnection;
    }

    static {
        try {
            if (Integer.parseInt((String)Class.forName("android.os.Build$VERSION").getField("SDK").get(null)) < 8) {
                System.setProperty("http.keepAlive", "false");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        instanceMap = new HashMap<HttpClientConfiguration, HttpClient>(1);
    }
}

