/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Account;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AccountJSONImpl
extends FacebookResponseImpl
implements Account,
Serializable {
    private static final long serialVersionUID = 1311323662169212743L;
    private String name;
    private String accessToken;
    private String category;
    private String id;
    private List<String> perms;

    AccountJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    AccountJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            if (!jSONObject.isNull("access_token")) {
                this.accessToken = z_F4JInternalParseUtil.getRawString("access_token", jSONObject);
            }
            this.category = z_F4JInternalParseUtil.getRawString("category", jSONObject);
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("perms")) {
                JSONArray jSONArray = jSONObject.getJSONArray("perms");
                int n2 = jSONArray.length();
                this.perms = new ArrayList<String>(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.perms.add((String)jSONArray.get(i2));
                }
            } else {
                this.perms = Collections.emptyList();
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<String> getPerms() {
        return this.perms;
    }

    static ResponseList<Account> createAccountList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Account> responseListImpl = new ResponseListImpl<Account>(n2, jSONObject, new Account[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                AccountJSONImpl accountJSONImpl = new AccountJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(accountJSONImpl, jSONObject2);
                }
                responseListImpl.add(accountJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AccountJSONImpl accountJSONImpl = (AccountJSONImpl)object;
        return !(this.id == null ? accountJSONImpl.id != null : !this.id.equals(accountJSONImpl.id));
    }

    public String toString() {
        return "AccountJSONImpl{name='" + this.name + '\'' + ", accessToken='" + this.accessToken + '\'' + ", category='" + this.category + '\'' + ", id='" + this.id + '\'' + ", perms=" + this.perms + '}';
    }
}

