/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Achievement;
import be.maximvdw.tabcore.facebook.Application;
import be.maximvdw.tabcore.facebook.Comment;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.IdNameEntity;
import be.maximvdw.tabcore.facebook.Like;
import be.maximvdw.tabcore.facebook.PagableList;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.ApplicationJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.CommentJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.LikeJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.PagableListImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AchievementJSONImpl
extends FacebookResponseImpl
implements Achievement,
Serializable {
    private static final long serialVersionUID = -4720957321727049130L;
    private String id;
    private IdNameEntity from;
    private Date startTime;
    private Date endTime;
    private Date publishTime;
    private Application application;
    private Integer importance;
    private Achievement.AchievedObject achievement;
    private PagableList<Like> likes;
    private PagableList<Comment> comments;

    AchievementJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    AchievementJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            FacebookResponseImpl facebookResponseImpl;
            int n2;
            int n3;
            JSONArray jSONArray;
            JSONObject jSONObject2;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                jSONObject2 = jSONObject.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(jSONObject2);
            }
            this.startTime = z_F4JInternalParseUtil.getISO8601Datetime("start_time", jSONObject);
            this.endTime = z_F4JInternalParseUtil.getISO8601Datetime("end_time", jSONObject);
            this.publishTime = z_F4JInternalParseUtil.getISO8601Datetime("publish_time", jSONObject);
            if (!jSONObject.isNull("application")) {
                jSONObject2 = jSONObject.getJSONObject("application");
                this.application = new ApplicationJSONImpl(jSONObject2);
            }
            if (!jSONObject.isNull("importance")) {
                this.importance = z_F4JInternalParseUtil.getPrimitiveInt("importance", jSONObject);
            }
            if (!jSONObject.isNull("achievement")) {
                this.achievement = new AchievedObjectJSONImpl(jSONObject.getJSONObject("achievement"));
            }
            if (!jSONObject.isNull("likes")) {
                jSONObject2 = jSONObject.getJSONObject("likes");
                if (!jSONObject2.isNull("data")) {
                    jSONArray = jSONObject2.getJSONArray("data");
                    n3 = jSONArray.length();
                    this.likes = new PagableListImpl<Like>(n3, jSONObject2, new Like[0]);
                    for (n2 = 0; n2 < n3; ++n2) {
                        facebookResponseImpl = new LikeJSONImpl(jSONArray.getJSONObject(n2));
                        this.likes.add(facebookResponseImpl);
                    }
                } else {
                    this.likes = new PagableListImpl<Like>(1, jSONObject2, new Like[0]);
                }
            } else {
                this.likes = new PagableListImpl<Like>(0);
            }
            if (!jSONObject.isNull("comments")) {
                jSONObject2 = jSONObject.getJSONObject("comments");
                if (!jSONObject2.isNull("data")) {
                    jSONArray = jSONObject2.getJSONArray("data");
                    n3 = jSONArray.length();
                    this.comments = new PagableListImpl<Comment>(n3, jSONObject2, new Comment[0]);
                    for (n2 = 0; n2 < n3; ++n2) {
                        facebookResponseImpl = new CommentJSONImpl(jSONArray.getJSONObject(n2));
                        this.comments.add(facebookResponseImpl);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, jSONObject2, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public Date getPublishTime() {
        return this.publishTime;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Integer getImportance() {
        return this.importance;
    }

    @Override
    public Achievement.AchievedObject getAchievement() {
        return this.achievement;
    }

    @Override
    public PagableList<Like> getLikes() {
        return this.likes;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    static ResponseList<Achievement> createAchievementList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Achievement> responseListImpl = new ResponseListImpl<Achievement>(n2, jSONObject, new Achievement[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                AchievementJSONImpl achievementJSONImpl = new AchievementJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(achievementJSONImpl, jSONObject2);
                }
                responseListImpl.add(achievementJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AchievementJSONImpl achievementJSONImpl = (AchievementJSONImpl)object;
        return !(this.id == null ? achievementJSONImpl.id != null : !this.id.equals(achievementJSONImpl.id));
    }

    public String toString() {
        return "AchievementJSONImpl [id=" + this.id + ", from=" + this.from + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", publishTime=" + this.publishTime + ", application=" + this.application + ", importance=" + this.importance + ", achievement=" + this.achievement + ", likes=" + this.likes + ", comments=" + this.comments + "]";
    }

    private final class AchievedObjectJSONImpl
    implements Achievement.AchievedObject,
    Serializable {
        private static final long serialVersionUID = 5301659229411941184L;
        private String id;
        private URL url;
        private String type;
        private String title;

        AchievedObjectJSONImpl(JSONObject jSONObject) {
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            this.url = z_F4JInternalParseUtil.getURL("url", jSONObject);
            this.type = z_F4JInternalParseUtil.getRawString("type", jSONObject);
            this.title = z_F4JInternalParseUtil.getRawString("title", jSONObject);
        }

        public String getId() {
            return this.id;
        }

        public URL getUrl() {
            return this.url;
        }

        public String getType() {
            return this.type;
        }

        public String getTitle() {
            return this.title;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.getOuterType().hashCode();
            n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            AchievedObjectJSONImpl achievedObjectJSONImpl = (AchievedObjectJSONImpl)object;
            if (!this.getOuterType().equals(achievedObjectJSONImpl.getOuterType())) {
                return false;
            }
            return !(this.id == null ? achievedObjectJSONImpl.id != null : !this.id.equals(achievedObjectJSONImpl.id));
        }

        public String toString() {
            return "AchievedObjectJSONImpl [id=" + this.id + ", url=" + this.url + ", type=" + this.type + ", title=" + this.title + "]";
        }

        private AchievementJSONImpl getOuterType() {
            return AchievementJSONImpl.this;
        }
    }
}

