/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Admin;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AdminJSONImpl
extends FacebookResponseImpl
implements Admin,
Serializable {
    private static final long serialVersionUID = 392257519791459917L;
    private String id;
    private String name;
    private String role;
    private List<String> perms;

    AdminJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    AdminJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
        this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
        this.role = z_F4JInternalParseUtil.getRawString("role", jSONObject);
        if (!jSONObject.isNull("perms")) {
            try {
                JSONArray jSONArray = jSONObject.getJSONArray("perms");
                int n2 = jSONArray.length();
                this.perms = new ArrayList<String>(n2);
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    this.perms.add(jSONArray.getString(i2));
                }
            }
            catch (JSONException jSONException) {
                throw new FacebookException(jSONException);
            }
        } else {
            this.perms = Collections.emptyList();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public List<String> getPerms() {
        return this.perms;
    }

    static ResponseList<Admin> createAdminList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Admin> responseListImpl = new ResponseListImpl<Admin>(n2, jSONObject, new Admin[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                AdminJSONImpl adminJSONImpl = new AdminJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(adminJSONImpl, jSONObject2);
                }
                responseListImpl.add(adminJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AdminJSONImpl adminJSONImpl = (AdminJSONImpl)object;
        return !(this.id == null ? adminJSONImpl.id != null : !this.id.equals(adminJSONImpl.id));
    }

    public String toString() {
        return "AdminJSONImpl{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", role='" + this.role + '\'' + ", perms=" + this.perms + '}';
    }
}

