/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Application;
import be.maximvdw.tabcore.facebook.Checkin;
import be.maximvdw.tabcore.facebook.Comment;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.GeoLocation;
import be.maximvdw.tabcore.facebook.IdNameEntity;
import be.maximvdw.tabcore.facebook.Like;
import be.maximvdw.tabcore.facebook.PagableList;
import be.maximvdw.tabcore.facebook.Place;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.ApplicationJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.CommentJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.LikeJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.PagableListImpl;
import be.maximvdw.tabcore.facebook.internal.json.PlaceJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CheckinJSONImpl
extends FacebookResponseImpl
implements Checkin,
Serializable {
    private static final long serialVersionUID = 2502877498804174869L;
    private String id;
    private IdNameEntity from;
    private PagableList<IdNameEntity> tags;
    private Place place;
    private Application application;
    private Date createdTime;
    private PagableList<Like> likes;
    private String message;
    private PagableList<Comment> comments;
    private String type;
    private GeoLocation coordinates;

    CheckinJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    CheckinJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            Serializable serializable;
            int n2;
            int n3;
            JSONArray jSONArray;
            JSONObject jSONObject2;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                jSONObject2 = jSONObject.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(jSONObject2);
            }
            if (!jSONObject.isNull("tags")) {
                jSONObject2 = jSONObject.getJSONObject("tags");
                jSONArray = jSONObject2.getJSONArray("data");
                n3 = jSONArray.length();
                this.tags = new PagableListImpl<IdNameEntity>(n3, jSONObject2, new IdNameEntity[0]);
                for (n2 = 0; n2 < n3; ++n2) {
                    serializable = new IdNameEntityJSONImpl(jSONArray.getJSONObject(n2));
                    this.tags.add(serializable);
                }
            } else {
                this.tags = new PagableListImpl<IdNameEntity>(0);
            }
            if (!jSONObject.isNull("place")) {
                jSONObject2 = jSONObject.getJSONObject("place");
                this.place = new PlaceJSONImpl(jSONObject2);
            }
            if (!jSONObject.isNull("application")) {
                jSONObject2 = jSONObject.getJSONObject("application");
                this.application = new ApplicationJSONImpl(jSONObject2);
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            if (!jSONObject.isNull("likes")) {
                jSONObject2 = jSONObject.getJSONObject("likes");
                if (!jSONObject2.isNull("data")) {
                    jSONArray = jSONObject2.getJSONArray("data");
                    n3 = jSONArray.length();
                    this.likes = new PagableListImpl<Like>(n3, jSONObject2, new Like[0]);
                    for (n2 = 0; n2 < n3; ++n2) {
                        serializable = new LikeJSONImpl(jSONArray.getJSONObject(n2));
                        this.likes.add(serializable);
                    }
                } else {
                    this.likes = new PagableListImpl<Like>(1, jSONObject2, new Like[0]);
                }
            } else {
                this.likes = new PagableListImpl<Like>(0);
            }
            this.message = z_F4JInternalParseUtil.getRawString("message", jSONObject);
            if (!jSONObject.isNull("comments")) {
                jSONObject2 = jSONObject.getJSONObject("comments");
                if (!jSONObject2.isNull("data")) {
                    jSONArray = jSONObject2.getJSONArray("data");
                    n3 = jSONArray.length();
                    this.comments = new PagableListImpl<Comment>(n3, jSONObject2, new Comment[0]);
                    for (n2 = 0; n2 < n3; ++n2) {
                        serializable = new CommentJSONImpl(jSONArray.getJSONObject(n2));
                        this.comments.add(serializable);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, jSONObject2, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
            this.type = z_F4JInternalParseUtil.getRawString("type", jSONObject);
            if (!jSONObject.isNull("coordinates")) {
                jSONObject2 = jSONObject.getJSONObject("coordinates");
                this.coordinates = new GeoLocation(jSONObject2.getDouble("latitude"), jSONObject2.getDouble("longitude"));
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public PagableList<IdNameEntity> getTags() {
        return this.tags;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public PagableList<Like> getLikes() {
        return this.likes;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public GeoLocation getCoordinates() {
        return this.coordinates;
    }

    static ResponseList<Checkin> createCheckinList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Checkin> responseListImpl = new ResponseListImpl<Checkin>(n2, jSONObject, new Checkin[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                CheckinJSONImpl checkinJSONImpl = new CheckinJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(checkinJSONImpl, jSONObject2);
                }
                responseListImpl.add(checkinJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CheckinJSONImpl checkinJSONImpl = (CheckinJSONImpl)object;
        return !(this.id == null ? checkinJSONImpl.id != null : !this.id.equals(checkinJSONImpl.id));
    }

    public String toString() {
        return "CheckinJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", tags=" + this.tags + ", place=" + this.place + ", application=" + this.application + ", createdTime=" + this.createdTime + ", likes=" + this.likes + ", message='" + this.message + '\'' + ", comments=" + this.comments + ", type='" + this.type + '\'' + ", coordinates=" + this.coordinates + '}';
    }
}

