/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.Group;
import be.maximvdw.tabcore.facebook.GroupPrivacyType;
import be.maximvdw.tabcore.facebook.IdNameEntity;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.Venue;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.json.VenueJSONImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GroupJSONImpl
extends FacebookResponseImpl
implements Group,
Serializable {
    private static final long serialVersionUID = 561347972556756182L;
    private Integer version;
    private String name;
    private String id;
    private Boolean administrator;
    private Integer bookmarkOrder;
    private IdNameEntity owner;
    private String description;
    private GroupPrivacyType privacy;
    private URL icon;
    private Date updatedTime;
    private String email;
    private Venue venue;

    GroupJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    GroupJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            if (!jSONObject.isNull("version")) {
                this.version = z_F4JInternalParseUtil.getPrimitiveInt("version", jSONObject);
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            this.administrator = z_F4JInternalParseUtil.getBoolean("administrator", jSONObject);
            if (!jSONObject.isNull("bookmark_order")) {
                this.bookmarkOrder = z_F4JInternalParseUtil.getPrimitiveInt("bookmark_order", jSONObject);
            }
            if (!jSONObject.isNull("owner")) {
                this.owner = new IdNameEntityJSONImpl(jSONObject.getJSONObject("owner"));
            }
            this.description = z_F4JInternalParseUtil.getRawString("description", jSONObject);
            this.privacy = GroupPrivacyType.getInstance(z_F4JInternalParseUtil.getRawString("privacy", jSONObject));
            this.icon = z_F4JInternalParseUtil.getURL("icon", jSONObject);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
            this.email = z_F4JInternalParseUtil.getRawString("email", jSONObject);
            if (!jSONObject.isNull("venue")) {
                this.venue = new VenueJSONImpl(jSONObject.getJSONObject("venue"));
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Boolean isAdministrator() {
        return this.administrator;
    }

    @Override
    public Integer getBookmarkOrder() {
        return this.bookmarkOrder;
    }

    @Override
    public IdNameEntity getOwner() {
        return this.owner;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public GroupPrivacyType getPrivacy() {
        return this.privacy;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public Venue getVenue() {
        return this.venue;
    }

    static ResponseList<Group> createGroupList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Group> responseListImpl = new ResponseListImpl<Group>(n2, jSONObject, new Group[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                GroupJSONImpl groupJSONImpl = new GroupJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(groupJSONImpl, jSONObject2);
                }
                responseListImpl.add(groupJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GroupJSONImpl groupJSONImpl = (GroupJSONImpl)object;
        return !(this.id == null ? groupJSONImpl.id != null : !this.id.equals(groupJSONImpl.id));
    }

    public String toString() {
        return "GroupJSONImpl{version=" + this.version + ", name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", administrator=" + this.administrator + ", bookmarkOrder=" + this.bookmarkOrder + ", owner=" + this.owner + ", description='" + this.description + '\'' + ", privacy=" + (Object)((Object)this.privacy) + ", icon=" + this.icon + ", updatedTime=" + this.updatedTime + ", email='" + this.email + '\'' + ", venue=" + this.venue + '}';
    }
}

