/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Category;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.Offer;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OfferJSONImpl
extends FacebookResponseImpl
implements Offer,
Serializable {
    private static final long serialVersionUID = -1552332355107913815L;
    private String id;
    private Category from;
    private String title;
    private Date createdTime;
    private Date expirationTime;
    private String terms;
    private URL imageURL;
    private Integer claimLimit;
    private String couponType;
    private URL redemptionLink;
    private String redemptionCode;
    private Boolean isPublished;
    private Integer scheduledPublishTime;
    private Date reminderTime;

    OfferJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    OfferJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("from");
                this.from = new CategoryJSONImpl(jSONObject2);
            }
            this.title = z_F4JInternalParseUtil.getRawString("title", jSONObject);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.expirationTime = z_F4JInternalParseUtil.getISO8601Datetime("expiration_time", jSONObject);
            this.terms = z_F4JInternalParseUtil.getRawString("terms", jSONObject);
            this.imageURL = z_F4JInternalParseUtil.getURL("image_url", jSONObject);
            this.claimLimit = z_F4JInternalParseUtil.getInt("claim_limit", jSONObject);
            this.couponType = z_F4JInternalParseUtil.getRawString("coupon_type", jSONObject);
            this.redemptionLink = z_F4JInternalParseUtil.getURL("redemption_link", jSONObject);
            this.redemptionCode = z_F4JInternalParseUtil.getRawString("redemption_code", jSONObject);
            this.isPublished = z_F4JInternalParseUtil.getBoolean("published", jSONObject);
            this.scheduledPublishTime = z_F4JInternalParseUtil.getInt("scheduled_publish_time", jSONObject);
            this.reminderTime = z_F4JInternalParseUtil.getISO8601Datetime("reminder_time", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public String getTerms() {
        return this.terms;
    }

    @Override
    public URL getImageURL() {
        return this.imageURL;
    }

    @Override
    public Integer getClaimLimit() {
        return this.claimLimit;
    }

    @Override
    public String getCouponType() {
        return this.couponType;
    }

    @Override
    public URL getRedemptionLink() {
        return this.redemptionLink;
    }

    @Override
    public String getRedemptionCode() {
        return this.redemptionCode;
    }

    @Override
    public Boolean isPublished() {
        return this.isPublished;
    }

    @Override
    public Integer getScheduledPublishTime() {
        return this.scheduledPublishTime;
    }

    @Override
    public Date getReminderTime() {
        return this.reminderTime;
    }

    static ResponseList<Offer> createOfferList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Offer> responseListImpl = new ResponseListImpl<Offer>(n2, jSONObject, new Offer[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                OfferJSONImpl offerJSONImpl = new OfferJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(offerJSONImpl, jSONObject2);
                }
                responseListImpl.add(offerJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OfferJSONImpl)) {
            return false;
        }
        OfferJSONImpl offerJSONImpl = (OfferJSONImpl)object;
        return !(this.id != null ? !this.id.equals(offerJSONImpl.id) : offerJSONImpl.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "OfferJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", title='" + this.title + '\'' + ", createdTime=" + this.createdTime + ", expirationTime=" + this.expirationTime + ", terms='" + this.terms + '\'' + ", imageURL=" + this.imageURL + ", claimLimit=" + this.claimLimit + ", couponType='" + this.couponType + '\'' + ", redemptionLink=" + this.redemptionLink + ", redemptionCode='" + this.redemptionCode + '\'' + ", isPublished=" + this.isPublished + ", scheduledPublishTime=" + this.scheduledPublishTime + ", reminderTime=" + this.reminderTime + '}';
    }
}

