/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.Reaction;
import be.maximvdw.tabcore.facebook.ReactionType;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReactionJSONImpl
extends CategoryJSONImpl
implements Reaction,
Serializable {
    private static final long serialVersionUID = 4813956293820850547L;
    private ReactionType type;

    ReactionJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse, configuration);
        this.init(httpResponse.asJSONObject());
    }

    ReactionJSONImpl(JSONObject jSONObject) {
        super(jSONObject);
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        this.type = ReactionType.of(z_F4JInternalParseUtil.getRawString("type", jSONObject));
    }

    public static ResponseList<Reaction> createReactionsList(HttpResponse httpResponse, Configuration configuration) {
        try {
            JSONObject jSONObject;
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            if ((jSONObject = httpResponse.asJSONObject()).has("reactions")) {
                jSONObject = jSONObject.getJSONObject("reactions");
            }
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Reaction> responseListImpl = new ResponseListImpl<Reaction>(n2, jSONObject, new Reaction[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                ReactionJSONImpl reactionJSONImpl = new ReactionJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(reactionJSONImpl, jSONObject2);
                }
                responseListImpl.add(reactionJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
        catch (FacebookException facebookException) {
            throw new FacebookException(facebookException.getMessage());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ReactionType getType() {
        return this.type;
    }
}

