/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Category;
import be.maximvdw.tabcore.facebook.Comment;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.PagableList;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.Tag;
import be.maximvdw.tabcore.facebook.Video;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.CommentJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.PagableListImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.json.TagJSONImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VideoJSONImpl
extends FacebookResponseImpl
implements Video,
Serializable {
    private static final long serialVersionUID = 7462511067275657778L;
    private String id;
    private Category from;
    private List<Tag> tags;
    private String name;
    private String description;
    private URL picture;
    private String embedHtml;
    private List<Video.Format> format;
    private URL icon;
    private URL source;
    private Date createdTime;
    private Date updatedTime;
    private PagableList<Comment> comments;
    private URL link;

    VideoJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    VideoJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            int n2;
            int n3;
            Object object;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                object = jSONObject.getJSONObject("from");
                this.from = new CategoryJSONImpl((JSONObject)object);
            }
            if (!jSONObject.isNull("tags")) {
                object = jSONObject.getJSONObject("tags");
                JSONArray jSONArray = ((JSONObject)object).getJSONArray("data");
                n3 = jSONArray.length();
                this.tags = new ArrayList<Tag>(n3);
                for (n2 = 0; n2 < n3; ++n2) {
                    this.tags.add(new TagJSONImpl(jSONArray.getJSONObject(n2)));
                }
            } else {
                this.tags = Collections.emptyList();
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            this.description = z_F4JInternalParseUtil.getRawString("description", jSONObject);
            this.picture = z_F4JInternalParseUtil.getURL("picture", jSONObject);
            this.embedHtml = z_F4JInternalParseUtil.getRawString("embed_html", jSONObject);
            if (!jSONObject.isNull("format")) {
                object = jSONObject.getJSONArray("format");
                int n4 = ((JSONArray)object).length();
                this.format = new ArrayList<Video.Format>(n4);
                for (n3 = 0; n3 < n4; ++n3) {
                    this.format.add(new FormatJSONImpl(((JSONArray)object).getJSONObject(n3)));
                }
            } else {
                this.format = Collections.emptyList();
            }
            this.icon = z_F4JInternalParseUtil.getURL("icon", jSONObject);
            this.source = z_F4JInternalParseUtil.getURL("source", jSONObject);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
            if (!jSONObject.isNull("comments")) {
                object = jSONObject.getJSONObject("comments");
                if (!((JSONObject)object).isNull("data")) {
                    JSONArray jSONArray = ((JSONObject)object).getJSONArray("data");
                    n3 = jSONArray.length();
                    this.comments = new PagableListImpl<Comment>(n3, (JSONObject)object, new Comment[0]);
                    for (n2 = 0; n2 < n3; ++n2) {
                        CommentJSONImpl commentJSONImpl = new CommentJSONImpl(jSONArray.getJSONObject(n2));
                        this.comments.add(commentJSONImpl);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, (JSONObject)object, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
            this.link = z_F4JInternalParseUtil.getURL("link", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public List<Tag> getTags() {
        return this.tags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public URL getPicture() {
        return this.picture;
    }

    @Override
    public String getEmbedHtml() {
        return this.embedHtml;
    }

    @Override
    public List<Video.Format> getFormat() {
        return this.format;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    @Override
    public URL getSource() {
        return this.source;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    static ResponseList<Video> createVideoList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Video> responseListImpl = new ResponseListImpl<Video>(n2, jSONObject, new Video[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                VideoJSONImpl videoJSONImpl = new VideoJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(videoJSONImpl, jSONObject2);
                }
                responseListImpl.add(videoJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VideoJSONImpl videoJSONImpl = (VideoJSONImpl)object;
        return !(this.id == null ? videoJSONImpl.id != null : !this.id.equals(videoJSONImpl.id));
    }

    public String toString() {
        return "VideoJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", tags=" + this.tags + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", picture=" + this.picture + ", embedHtml='" + this.embedHtml + '\'' + ", format=" + this.format + ", icon=" + this.icon + ", source=" + this.source + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", comments=" + this.comments + ", link=" + this.link + '}';
    }

    private final class FormatJSONImpl
    implements Video.Format,
    Serializable {
        private static final long serialVersionUID = 3289798902942149539L;
        private String embedHtml;
        private String filter;
        private Integer height;
        private Integer width;
        private URL picture;

        FormatJSONImpl(JSONObject jSONObject) {
            this.embedHtml = z_F4JInternalParseUtil.getRawString("embed_html", jSONObject);
            this.filter = z_F4JInternalParseUtil.getRawString("filter", jSONObject);
            this.height = z_F4JInternalParseUtil.getInt("height", jSONObject);
            this.width = z_F4JInternalParseUtil.getInt("width", jSONObject);
            this.picture = z_F4JInternalParseUtil.getURL("picture", jSONObject);
        }

        public String getEmbedHtml() {
            return this.embedHtml;
        }

        public String getFilter() {
            return this.filter;
        }

        public Integer getHeight() {
            return this.height;
        }

        public Integer getWidth() {
            return this.width;
        }

        public URL getPicture() {
            return this.picture;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FormatJSONImpl)) {
                return false;
            }
            FormatJSONImpl formatJSONImpl = (FormatJSONImpl)object;
            if (this.embedHtml != null ? !this.embedHtml.equals(formatJSONImpl.embedHtml) : formatJSONImpl.embedHtml != null) {
                return false;
            }
            if (this.filter != null ? !this.filter.equals(formatJSONImpl.filter) : formatJSONImpl.filter != null) {
                return false;
            }
            if (this.height != null ? !this.height.equals(formatJSONImpl.height) : formatJSONImpl.height != null) {
                return false;
            }
            if (this.picture != null ? !this.picture.equals(formatJSONImpl.picture) : formatJSONImpl.picture != null) {
                return false;
            }
            return !(this.width != null ? !this.width.equals(formatJSONImpl.width) : formatJSONImpl.width != null);
        }

        public int hashCode() {
            int n2 = this.embedHtml != null ? this.embedHtml.hashCode() : 0;
            n2 = 31 * n2 + (this.filter != null ? this.filter.hashCode() : 0);
            n2 = 31 * n2 + (this.height != null ? this.height.hashCode() : 0);
            n2 = 31 * n2 + (this.width != null ? this.width.hashCode() : 0);
            n2 = 31 * n2 + (this.picture != null ? this.picture.hashCode() : 0);
            return n2;
        }

        public String toString() {
            return "FormatJSONImpl{embedHtml='" + this.embedHtml + '\'' + ", filter='" + this.filter + '\'' + ", height=" + this.height + ", width=" + this.width + ", picture=" + this.picture + '}';
        }
    }
}

