/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.Category;
import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.ParseUtil;
import be.maximvdw.tabcore.twitter.ResponseList;
import be.maximvdw.tabcore.twitter.ResponseListImpl;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.TwitterObjectFactory;
import be.maximvdw.tabcore.twitter.conf.Configuration;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CategoryJSONImpl
implements Category,
Serializable {
    private static final long serialVersionUID = 3811335888122469876L;
    private String name;
    private String slug;
    private int size;

    CategoryJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    void init(JSONObject jSONObject) {
        this.name = jSONObject.getString("name");
        this.slug = jSONObject.getString("slug");
        this.size = ParseUtil.getInt("size", jSONObject);
    }

    static ResponseList<Category> createCategoriesList(HttpResponse httpResponse, Configuration configuration) {
        return CategoryJSONImpl.createCategoriesList(httpResponse.asJSONArray(), httpResponse, configuration);
    }

    static ResponseList<Category> createCategoriesList(JSONArray jSONArray, HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            ResponseListImpl<Category> responseListImpl = new ResponseListImpl<Category>(jSONArray.length(), httpResponse);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                CategoryJSONImpl categoryJSONImpl = new CategoryJSONImpl(jSONObject);
                responseListImpl.add(categoryJSONImpl);
                if (!configuration.isJSONStoreEnabled()) continue;
                TwitterObjectFactory.registerJSONObject(categoryJSONImpl, jSONObject);
            }
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CategoryJSONImpl categoryJSONImpl = (CategoryJSONImpl)object;
        if (this.size != categoryJSONImpl.size) {
            return false;
        }
        if (this.name != null ? !this.name.equals(categoryJSONImpl.name) : categoryJSONImpl.name != null) {
            return false;
        }
        return !(this.slug != null ? !this.slug.equals(categoryJSONImpl.slug) : categoryJSONImpl.slug != null);
    }

    public int hashCode() {
        int n2 = this.name != null ? this.name.hashCode() : 0;
        n2 = 31 * n2 + (this.slug != null ? this.slug.hashCode() : 0);
        n2 = 31 * n2 + this.size;
        return n2;
    }

    public String toString() {
        return "CategoryJSONImpl{name='" + this.name + '\'' + ", slug='" + this.slug + '\'' + ", size=" + this.size + '}';
    }
}

