/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HttpClient;
import be.maximvdw.tabcore.twitter.HttpClientConfiguration;
import be.maximvdw.tabcore.twitter.conf.ConfigurationContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public final class HttpClientFactory {
    private static final Constructor<?> HTTP_CLIENT_CONSTRUCTOR;
    private static final String HTTP_CLIENT_IMPLEMENTATION = "be.maximvdw.tabcore.twitter.http.httpClient";
    private static final HashMap<HttpClientConfiguration, HttpClient> confClientMap;

    public static HttpClient getInstance() {
        return HttpClientFactory.getInstance(ConfigurationContext.getInstance().getHttpClientConfiguration());
    }

    public static HttpClient getInstance(HttpClientConfiguration httpClientConfiguration) {
        HttpClient httpClient = confClientMap.get(httpClientConfiguration);
        try {
            if (httpClient == null) {
                httpClient = (HttpClient)HTTP_CLIENT_CONSTRUCTOR.newInstance(httpClientConfiguration);
                confClientMap.put(httpClientConfiguration, httpClient);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
        return httpClient;
    }

    static {
        Class<?> clazz = null;
        String string = System.getProperty(HTTP_CLIENT_IMPLEMENTATION);
        if (string != null) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (null == clazz) {
            try {
                clazz = Class.forName("be.maximvdw.tabcore.twitter.AlternativeHttpClientImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (null == clazz) {
            try {
                clazz = Class.forName("be.maximvdw.tabcore.twitter.HttpClientImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }
        try {
            HTTP_CLIENT_CONSTRUCTOR = clazz.getConstructor(HttpClientConfiguration.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        confClientMap = new HashMap();
    }
}

