/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HttpClientConfiguration;
import be.maximvdw.tabcore.twitter.HttpResponseImpl;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.JSONTokener;
import be.maximvdw.tabcore.twitter.Logger;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.conf.ConfigurationContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpResponse {
    private static final Logger logger = Logger.getLogger(HttpResponseImpl.class);
    protected final HttpClientConfiguration CONF;
    protected int statusCode;
    protected String responseAsString = null;
    protected InputStream is;
    private boolean streamConsumed = false;
    private JSONObject json = null;
    private JSONArray jsonArray = null;

    HttpResponse() {
        this.CONF = ConfigurationContext.getInstance().getHttpClientConfiguration();
    }

    public HttpResponse(HttpClientConfiguration httpClientConfiguration) {
        this.CONF = httpClientConfiguration;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public abstract String getResponseHeader(String var1);

    public abstract Map<String, List<String>> getResponseHeaderFields();

    public InputStream asStream() {
        if (this.streamConsumed) {
            throw new IllegalStateException("Stream has already been consumed.");
        }
        return this.is;
    }

    public String asString() {
        if (null == this.responseAsString) {
            BufferedReader bufferedReader = null;
            InputStream inputStream = null;
            try {
                String string;
                inputStream = this.asStream();
                if (null == inputStream) {
                    String string2 = null;
                    return string2;
                }
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string).append("\n");
                }
                this.responseAsString = stringBuilder.toString();
                logger.debug(this.responseAsString);
                inputStream.close();
                this.streamConsumed = true;
            }
            catch (IOException iOException) {
                throw new TwitterException(iOException.getMessage(), iOException);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                this.disconnectForcibly();
            }
        }
        return this.responseAsString;
    }

    public JSONObject asJSONObject() {
        if (this.json == null) {
            Reader reader = null;
            try {
                if (this.responseAsString == null) {
                    reader = this.asReader();
                    this.json = new JSONObject(new JSONTokener(reader));
                } else {
                    this.json = new JSONObject(this.responseAsString);
                }
                if (this.CONF.isPrettyDebugEnabled()) {
                    logger.debug(this.json.toString(1));
                } else {
                    logger.debug(this.responseAsString != null ? this.responseAsString : this.json.toString());
                }
            }
            catch (JSONException jSONException) {
                if (this.responseAsString == null) {
                    throw new TwitterException(jSONException.getMessage(), jSONException);
                }
                throw new TwitterException(jSONException.getMessage() + ":" + this.responseAsString, jSONException);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                this.disconnectForcibly();
            }
        }
        return this.json;
    }

    public JSONArray asJSONArray() {
        if (this.jsonArray == null) {
            Reader reader = null;
            try {
                if (this.responseAsString == null) {
                    reader = this.asReader();
                    this.jsonArray = new JSONArray(new JSONTokener(reader));
                } else {
                    this.jsonArray = new JSONArray(this.responseAsString);
                }
                if (this.CONF.isPrettyDebugEnabled()) {
                    logger.debug(this.jsonArray.toString(1));
                } else {
                    logger.debug(this.responseAsString != null ? this.responseAsString : this.jsonArray.toString());
                }
            }
            catch (JSONException jSONException) {
                if (logger.isDebugEnabled()) {
                    throw new TwitterException(jSONException.getMessage() + ":" + this.responseAsString, jSONException);
                }
                throw new TwitterException(jSONException.getMessage(), jSONException);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                this.disconnectForcibly();
            }
        }
        return this.jsonArray;
    }

    public Reader asReader() {
        try {
            return new BufferedReader(new InputStreamReader(this.is, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new InputStreamReader(this.is);
        }
    }

    private void disconnectForcibly() {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void disconnect();

    public String toString() {
        return "HttpResponse{statusCode=" + this.statusCode + ", responseAsString='" + this.responseAsString + '\'' + ", is=" + this.is + ", streamConsumed=" + this.streamConsumed + '}';
    }
}

