/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.ResponseList;
import be.maximvdw.tabcore.twitter.ResponseListImpl;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.TwitterObjectFactory;
import be.maximvdw.tabcore.twitter.api.HelpResources;
import be.maximvdw.tabcore.twitter.conf.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageJSONImpl
implements HelpResources.Language {
    private String name;
    private String code;
    private String status;

    LanguageJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            this.name = jSONObject.getString("name");
            this.code = jSONObject.getString("code");
            this.status = jSONObject.getString("status");
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    static ResponseList<HelpResources.Language> createLanguageList(HttpResponse httpResponse, Configuration configuration) {
        return LanguageJSONImpl.createLanguageList(httpResponse.asJSONArray(), httpResponse, configuration);
    }

    static ResponseList<HelpResources.Language> createLanguageList(JSONArray jSONArray, HttpResponse httpResponse, Configuration configuration) {
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
        }
        try {
            int n2 = jSONArray.length();
            ResponseListImpl<HelpResources.Language> responseListImpl = new ResponseListImpl<HelpResources.Language>(n2, httpResponse);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                LanguageJSONImpl languageJSONImpl = new LanguageJSONImpl(jSONObject);
                responseListImpl.add(languageJSONImpl);
                if (!configuration.isJSONStoreEnabled()) continue;
                TwitterObjectFactory.registerJSONObject(languageJSONImpl, jSONObject);
            }
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }
}

