/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.GeoLocation;
import be.maximvdw.tabcore.twitter.HttpParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Query
implements Serializable {
    private static final long serialVersionUID = 7196404519192910019L;
    private String query = null;
    private String lang = null;
    private String locale = null;
    private long maxId = -1L;
    private int count = -1;
    private String since = null;
    private long sinceId = -1L;
    private String geocode = null;
    private String until = null;
    private ResultType resultType = null;
    private String nextPageQuery = null;
    public static final Unit MILES = Unit.mi;
    public static final Unit KILOMETERS = Unit.km;
    public static final ResultType MIXED = ResultType.mixed;
    public static final ResultType POPULAR = ResultType.popular;
    public static final ResultType RECENT = ResultType.recent;
    private static final HttpParameter WITH_TWITTER_USER_ID = new HttpParameter("with_twitter_user_id", "true");

    public Query() {
    }

    public Query(String string) {
        this.query = string;
    }

    static Query createWithNextPageQuery(String string) {
        Query query = new Query();
        query.nextPageQuery = string;
        if (string != null) {
            String string2 = string.substring(1, string.length());
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (HttpParameter httpParameter : HttpParameter.decodeParameters(string2)) {
                linkedHashMap.put(httpParameter.getName(), httpParameter.getValue());
            }
            if (linkedHashMap.containsKey("q")) {
                query.setQuery((String)linkedHashMap.get("q"));
            }
            if (linkedHashMap.containsKey("lang")) {
                query.setLang((String)linkedHashMap.get("lang"));
            }
            if (linkedHashMap.containsKey("locale")) {
                query.setLocale((String)linkedHashMap.get("locale"));
            }
            if (linkedHashMap.containsKey("max_id")) {
                query.setMaxId(Long.parseLong((String)linkedHashMap.get("max_id")));
            }
            if (linkedHashMap.containsKey("count")) {
                query.setCount(Integer.parseInt((String)linkedHashMap.get("count")));
            }
            if (linkedHashMap.containsKey("geocode")) {
                String[] stringArray = ((String)linkedHashMap.get("geocode")).split(",");
                double d2 = Double.parseDouble(stringArray[0]);
                double d3 = Double.parseDouble(stringArray[1]);
                double d4 = 0.0;
                Unit unit = null;
                String string3 = stringArray[2];
                for (Unit unit2 : Unit.values()) {
                    if (!string3.endsWith(unit2.name())) continue;
                    d4 = Double.parseDouble(string3.substring(0, string3.length() - 2));
                    unit = unit2;
                    break;
                }
                if (unit == null) {
                    throw new IllegalArgumentException("unrecognized geocode radius: " + string3);
                }
                query.setGeoCode(new GeoLocation(d2, d3), d4, unit);
            }
            if (linkedHashMap.containsKey("result_type")) {
                query.setResultType(ResultType.valueOf((String)linkedHashMap.get("result_type")));
            }
        }
        return query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public Query query(String string) {
        this.setQuery(string);
        return this;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String string) {
        this.lang = string;
    }

    public Query lang(String string) {
        this.setLang(string);
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String string) {
        this.locale = string;
    }

    public Query locale(String string) {
        this.setLocale(string);
        return this;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public void setMaxId(long l2) {
        this.maxId = l2;
    }

    public Query maxId(long l2) {
        this.setMaxId(l2);
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n2) {
        this.count = n2;
    }

    public Query count(int n2) {
        this.setCount(n2);
        return this;
    }

    public String getSince() {
        return this.since;
    }

    public void setSince(String string) {
        this.since = string;
    }

    public Query since(String string) {
        this.setSince(string);
        return this;
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setSinceId(long l2) {
        this.sinceId = l2;
    }

    public Query sinceId(long l2) {
        this.setSinceId(l2);
        return this;
    }

    public String getGeocode() {
        return this.geocode;
    }

    public void setGeoCode(GeoLocation geoLocation, double d2, Unit unit) {
        this.geocode = geoLocation.getLatitude() + "," + geoLocation.getLongitude() + "," + d2 + unit.name();
    }

    public void setGeoCode(GeoLocation geoLocation, double d2, String string) {
        this.geocode = geoLocation.getLatitude() + "," + geoLocation.getLongitude() + "," + d2 + string;
    }

    public Query geoCode(GeoLocation geoLocation, double d2, String string) {
        this.setGeoCode(geoLocation, d2, string);
        return this;
    }

    public String getUntil() {
        return this.until;
    }

    public void setUntil(String string) {
        this.until = string;
    }

    public Query until(String string) {
        this.setUntil(string);
        return this;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    public Query resultType(ResultType resultType) {
        this.setResultType(resultType);
        return this;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>(12);
        this.appendParameter("q", this.query, arrayList);
        this.appendParameter("lang", this.lang, arrayList);
        this.appendParameter("locale", this.locale, arrayList);
        this.appendParameter("max_id", this.maxId, arrayList);
        this.appendParameter("count", this.count, arrayList);
        this.appendParameter("since", this.since, arrayList);
        this.appendParameter("since_id", this.sinceId, arrayList);
        this.appendParameter("geocode", this.geocode, arrayList);
        this.appendParameter("until", this.until, arrayList);
        if (this.resultType != null) {
            arrayList.add(new HttpParameter("result_type", this.resultType.name()));
        }
        arrayList.add(WITH_TWITTER_USER_ID);
        HttpParameter[] httpParameterArray = new HttpParameter[arrayList.size()];
        return arrayList.toArray(httpParameterArray);
    }

    private void appendParameter(String string, String string2, List<HttpParameter> list) {
        if (string2 != null) {
            list.add(new HttpParameter(string, string2));
        }
    }

    private void appendParameter(String string, long l2, List<HttpParameter> list) {
        if (0L <= l2) {
            list.add(new HttpParameter(string, String.valueOf(l2)));
        }
    }

    String nextPage() {
        return this.nextPageQuery;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Query query = (Query)object;
        if (this.maxId != query.maxId) {
            return false;
        }
        if (this.count != query.count) {
            return false;
        }
        if (this.sinceId != query.sinceId) {
            return false;
        }
        if (this.geocode != null ? !this.geocode.equals(query.geocode) : query.geocode != null) {
            return false;
        }
        if (this.lang != null ? !this.lang.equals(query.lang) : query.lang != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(query.locale) : query.locale != null) {
            return false;
        }
        if (this.nextPageQuery != null ? !this.nextPageQuery.equals(query.nextPageQuery) : query.nextPageQuery != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(query.query) : query.query != null) {
            return false;
        }
        if (this.resultType != null ? !this.resultType.equals((Object)query.resultType) : query.resultType != null) {
            return false;
        }
        if (this.since != null ? !this.since.equals(query.since) : query.since != null) {
            return false;
        }
        return !(this.until != null ? !this.until.equals(query.until) : query.until != null);
    }

    public int hashCode() {
        int n2 = this.query != null ? this.query.hashCode() : 0;
        n2 = 31 * n2 + (this.lang != null ? this.lang.hashCode() : 0);
        n2 = 31 * n2 + (this.locale != null ? this.locale.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.maxId ^ this.maxId >>> 32);
        n2 = 31 * n2 + this.count;
        n2 = 31 * n2 + (this.since != null ? this.since.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.sinceId ^ this.sinceId >>> 32);
        n2 = 31 * n2 + (this.geocode != null ? this.geocode.hashCode() : 0);
        n2 = 31 * n2 + (this.until != null ? this.until.hashCode() : 0);
        n2 = 31 * n2 + (this.resultType != null ? this.resultType.hashCode() : 0);
        n2 = 31 * n2 + (this.nextPageQuery != null ? this.nextPageQuery.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "Query{query='" + this.query + '\'' + ", lang='" + this.lang + '\'' + ", locale='" + this.locale + '\'' + ", maxId=" + this.maxId + ", count=" + this.count + ", since='" + this.since + '\'' + ", sinceId=" + this.sinceId + ", geocode='" + this.geocode + '\'' + ", until='" + this.until + '\'' + ", resultType='" + (Object)((Object)this.resultType) + '\'' + ", nextPageQuery='" + this.nextPageQuery + '\'' + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResultType {
        popular,
        mixed,
        recent;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Unit {
        mi,
        km;

    }
}

