/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.Logger;
import be.maximvdw.tabcore.twitter.management.APIStatistics;
import be.maximvdw.tabcore.twitter.management.APIStatisticsMBean;
import be.maximvdw.tabcore.twitter.management.APIStatisticsOpenMBean;
import java.lang.management.ManagementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class TwitterAPIMonitor {
    private static final Logger logger = Logger.getLogger(TwitterAPIMonitor.class);
    private static final Pattern pattern = Pattern.compile("https?://[^/]+/[0-9.]*/([a-zA-Z_\\.]*).*");
    private static final TwitterAPIMonitor SINGLETON = new TwitterAPIMonitor();
    private static final APIStatistics STATISTICS = new APIStatistics(100);

    private TwitterAPIMonitor() {
    }

    public static TwitterAPIMonitor getInstance() {
        return SINGLETON;
    }

    public APIStatisticsMBean getStatistics() {
        return STATISTICS;
    }

    void methodCalled(String string, long l2, boolean bl2) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches() && matcher.groupCount() > 0) {
            String string2 = matcher.group(1);
            STATISTICS.methodCalled(string2, l2, bl2);
        }
    }

    static {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("be.maximvdw.tabcore.twitter.mbean:type=APIStatisticsOpenMBean");
            APIStatisticsOpenMBean aPIStatisticsOpenMBean = new APIStatisticsOpenMBean(STATISTICS);
            mBeanServer.registerMBean(aPIStatisticsOpenMBean, objectName);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            instanceAlreadyExistsException.printStackTrace();
            logger.error(instanceAlreadyExistsException.getMessage());
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            mBeanRegistrationException.printStackTrace();
            logger.error(mBeanRegistrationException.getMessage());
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            notCompliantMBeanException.printStackTrace();
            logger.error(notCompliantMBeanException.getMessage());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            malformedObjectNameException.printStackTrace();
            logger.error(malformedObjectNameException.getMessage());
        }
    }
}

