/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.AccountTotals;
import be.maximvdw.tabcore.twitter.AccountTotalsJSONImpl;
import be.maximvdw.tabcore.twitter.Category;
import be.maximvdw.tabcore.twitter.CategoryJSONImpl;
import be.maximvdw.tabcore.twitter.DirectMessage;
import be.maximvdw.tabcore.twitter.DirectMessageJSONImpl;
import be.maximvdw.tabcore.twitter.IDs;
import be.maximvdw.tabcore.twitter.IDsJSONImpl;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.JSONObjectType;
import be.maximvdw.tabcore.twitter.Location;
import be.maximvdw.tabcore.twitter.LocationJSONImpl;
import be.maximvdw.tabcore.twitter.OEmbed;
import be.maximvdw.tabcore.twitter.OEmbedJSONImpl;
import be.maximvdw.tabcore.twitter.Place;
import be.maximvdw.tabcore.twitter.PlaceJSONImpl;
import be.maximvdw.tabcore.twitter.RateLimitStatus;
import be.maximvdw.tabcore.twitter.RateLimitStatusJSONImpl;
import be.maximvdw.tabcore.twitter.Relationship;
import be.maximvdw.tabcore.twitter.RelationshipJSONImpl;
import be.maximvdw.tabcore.twitter.SavedSearch;
import be.maximvdw.tabcore.twitter.SavedSearchJSONImpl;
import be.maximvdw.tabcore.twitter.Status;
import be.maximvdw.tabcore.twitter.StatusDeletionNoticeImpl;
import be.maximvdw.tabcore.twitter.StatusJSONImpl;
import be.maximvdw.tabcore.twitter.Trend;
import be.maximvdw.tabcore.twitter.TrendJSONImpl;
import be.maximvdw.tabcore.twitter.Trends;
import be.maximvdw.tabcore.twitter.TrendsJSONImpl;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.User;
import be.maximvdw.tabcore.twitter.UserJSONImpl;
import be.maximvdw.tabcore.twitter.UserList;
import be.maximvdw.tabcore.twitter.UserListJSONImpl;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TwitterObjectFactory {
    private static final ThreadLocal<Map> rawJsonMap = new ThreadLocal<Map>(){

        @Override
        protected Map initialValue() {
            return new HashMap();
        }
    };
    private static boolean registeredAtleastOnce = false;

    private TwitterObjectFactory() {
        throw new AssertionError((Object)"not intended to be instantiated.");
    }

    public static String getRawJSON(Object object) {
        if (!registeredAtleastOnce) {
            throw new IllegalStateException("Apparently jsonStoreEnabled is not set to true.");
        }
        Object v2 = rawJsonMap.get().get(object);
        if (v2 instanceof String) {
            return (String)v2;
        }
        if (v2 != null) {
            return v2.toString();
        }
        return null;
    }

    public static Status createStatus(String string) {
        try {
            return new StatusJSONImpl(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static User createUser(String string) {
        try {
            return new UserJSONImpl(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static AccountTotals createAccountTotals(String string) {
        try {
            return new AccountTotalsJSONImpl(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static Relationship createRelationship(String string) {
        try {
            return new RelationshipJSONImpl(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static Place createPlace(String string) {
        try {
            return new PlaceJSONImpl(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static SavedSearch createSavedSearch(String string) {
        try {
            return new SavedSearchJSONImpl(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static Trend createTrend(String string) {
        try {
            return new TrendJSONImpl(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static Trends createTrends(String string) {
        return new TrendsJSONImpl(string);
    }

    public static IDs createIDs(String string) {
        return new IDsJSONImpl(string);
    }

    public static Map<String, RateLimitStatus> createRateLimitStatus(String string) {
        try {
            return RateLimitStatusJSONImpl.createRateLimitStatuses(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static Category createCategory(String string) {
        try {
            return new CategoryJSONImpl(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static DirectMessage createDirectMessage(String string) {
        try {
            return new DirectMessageJSONImpl(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static Location createLocation(String string) {
        try {
            return new LocationJSONImpl(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static UserList createUserList(String string) {
        try {
            return new UserListJSONImpl(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static OEmbed createOEmbed(String string) {
        try {
            return new OEmbedJSONImpl(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static Object createObject(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            JSONObjectType.Type type = JSONObjectType.determine(jSONObject);
            switch (type) {
                case SENDER: {
                    return TwitterObjectFactory.registerJSONObject(new DirectMessageJSONImpl(jSONObject.getJSONObject("direct_message")), jSONObject);
                }
                case STATUS: {
                    return TwitterObjectFactory.registerJSONObject(new StatusJSONImpl(jSONObject), jSONObject);
                }
                case DIRECT_MESSAGE: {
                    return TwitterObjectFactory.registerJSONObject(new DirectMessageJSONImpl(jSONObject.getJSONObject("direct_message")), jSONObject);
                }
                case DELETE: {
                    return TwitterObjectFactory.registerJSONObject(new StatusDeletionNoticeImpl(jSONObject.getJSONObject("delete").getJSONObject("status")), jSONObject);
                }
                case LIMIT: {
                    return jSONObject;
                }
                case SCRUB_GEO: {
                    return jSONObject;
                }
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    static void clearThreadLocalMap() {
        rawJsonMap.get().clear();
    }

    static <T> T registerJSONObject(T t2, Object object) {
        registeredAtleastOnce = true;
        rawJsonMap.get().put(t2, object);
        return t2;
    }
}

