/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.EntityIndex;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.URLEntity;

final class URLEntityJSONImpl
extends EntityIndex
implements URLEntity {
    private static final long serialVersionUID = 7333552738058031524L;
    private String url;
    private String expandedURL;
    private String displayURL;

    URLEntityJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    URLEntityJSONImpl(int n2, int n3, String string, String string2, String string3) {
        this.setStart(n2);
        this.setEnd(n3);
        this.url = string;
        this.expandedURL = string2;
        this.displayURL = string3;
    }

    URLEntityJSONImpl() {
    }

    private void init(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("indices");
            this.setStart(jSONArray.getInt(0));
            this.setEnd(jSONArray.getInt(1));
            this.url = jSONObject.getString("url");
            this.expandedURL = !jSONObject.isNull("expanded_url") ? jSONObject.getString("expanded_url") : this.url;
            this.displayURL = !jSONObject.isNull("display_url") ? jSONObject.getString("display_url") : this.url;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public String getText() {
        return this.url;
    }

    public String getURL() {
        return this.url;
    }

    public String getExpandedURL() {
        return this.expandedURL;
    }

    public String getDisplayURL() {
        return this.displayURL;
    }

    public int getStart() {
        return super.getStart();
    }

    public int getEnd() {
        return super.getEnd();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        URLEntityJSONImpl uRLEntityJSONImpl = (URLEntityJSONImpl)object;
        if (this.displayURL != null ? !this.displayURL.equals(uRLEntityJSONImpl.displayURL) : uRLEntityJSONImpl.displayURL != null) {
            return false;
        }
        if (this.expandedURL != null ? !this.expandedURL.equals(uRLEntityJSONImpl.expandedURL) : uRLEntityJSONImpl.expandedURL != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(uRLEntityJSONImpl.url) : uRLEntityJSONImpl.url != null);
    }

    public int hashCode() {
        int n2 = this.url != null ? this.url.hashCode() : 0;
        n2 = 31 * n2 + (this.expandedURL != null ? this.expandedURL.hashCode() : 0);
        n2 = 31 * n2 + (this.displayURL != null ? this.displayURL.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "URLEntityJSONImpl{url='" + this.url + '\'' + ", expandedURL='" + this.expandedURL + '\'' + ", displayURL='" + this.displayURL + '\'' + '}';
    }
}

