/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter.auth;

import be.maximvdw.tabcore.twitter.BASE64Encoder;
import be.maximvdw.tabcore.twitter.HttpRequest;
import be.maximvdw.tabcore.twitter.auth.Authorization;
import java.io.Serializable;

public class BasicAuthorization
implements Authorization,
Serializable {
    private static final long serialVersionUID = 7420629998989177351L;
    private final String userId;
    private final String password;
    private final String basic;

    public BasicAuthorization(String string, String string2) {
        this.userId = string;
        this.password = string2;
        this.basic = this.encodeBasicAuthenticationString();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    private String encodeBasicAuthenticationString() {
        if (this.userId != null && this.password != null) {
            return "Basic " + BASE64Encoder.encode((this.userId + ":" + this.password).getBytes());
        }
        return null;
    }

    public String getAuthorizationHeader(HttpRequest httpRequest) {
        return this.basic;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BasicAuthorization)) {
            return false;
        }
        BasicAuthorization basicAuthorization = (BasicAuthorization)object;
        return this.basic.equals(basicAuthorization.basic);
    }

    public int hashCode() {
        return this.basic.hashCode();
    }

    public String toString() {
        return "BasicAuthorization{userId='" + this.userId + '\'' + ", password='**********''" + '}';
    }
}

