/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter.auth;

import be.maximvdw.tabcore.twitter.BASE64Encoder;
import be.maximvdw.tabcore.twitter.HttpClient;
import be.maximvdw.tabcore.twitter.HttpClientFactory;
import be.maximvdw.tabcore.twitter.HttpParameter;
import be.maximvdw.tabcore.twitter.HttpRequest;
import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.auth.Authorization;
import be.maximvdw.tabcore.twitter.auth.OAuth2Support;
import be.maximvdw.tabcore.twitter.auth.OAuth2Token;
import be.maximvdw.tabcore.twitter.conf.Configuration;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class OAuth2Authorization
implements Authorization,
OAuth2Support,
Serializable {
    private static final long serialVersionUID = -2895232598422218647L;
    private final Configuration conf;
    private final HttpClient http;
    private String consumerKey;
    private String consumerSecret;
    private OAuth2Token token;

    public OAuth2Authorization(Configuration configuration) {
        this.conf = configuration;
        this.setOAuthConsumer(configuration.getOAuthConsumerKey(), configuration.getOAuthConsumerSecret());
        this.http = HttpClientFactory.getInstance(configuration.getHttpClientConfiguration());
    }

    public void setOAuthConsumer(String string, String string2) {
        this.consumerKey = string != null ? string : "";
        this.consumerSecret = string2 != null ? string2 : "";
    }

    public OAuth2Token getOAuth2Token() {
        HttpResponse httpResponse;
        if (this.token != null) {
            throw new IllegalStateException("OAuth 2 Bearer Token is already available.");
        }
        HttpParameter[] httpParameterArray = new HttpParameter[this.conf.getOAuth2Scope() == null ? 1 : 2];
        httpParameterArray[0] = new HttpParameter("grant_type", "client_credentials");
        if (this.conf.getOAuth2Scope() != null) {
            httpParameterArray[1] = new HttpParameter("scope", this.conf.getOAuth2Scope());
        }
        if ((httpResponse = this.http.post(this.conf.getOAuth2TokenURL(), httpParameterArray, this, null)).getStatusCode() != 200) {
            throw new TwitterException("Obtaining OAuth 2 Bearer Token failed.", httpResponse);
        }
        this.token = new OAuth2Token(httpResponse);
        return this.token;
    }

    public void setOAuth2Token(OAuth2Token oAuth2Token) {
        this.token = oAuth2Token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateOAuth2Token() {
        if (this.token == null) {
            throw new IllegalStateException("OAuth 2 Bearer Token is not available.");
        }
        HttpParameter[] httpParameterArray = new HttpParameter[]{new HttpParameter("access_token", this.token.getAccessToken())};
        OAuth2Token oAuth2Token = this.token;
        boolean bl2 = false;
        try {
            this.token = null;
            HttpResponse httpResponse = this.http.post(this.conf.getOAuth2InvalidateTokenURL(), httpParameterArray, this, null);
            if (httpResponse.getStatusCode() != 200) {
                throw new TwitterException("Invalidating OAuth 2 Bearer Token failed.", httpResponse);
            }
            bl2 = true;
        }
        finally {
            if (!bl2) {
                this.token = oAuth2Token;
            }
        }
    }

    public String getAuthorizationHeader(HttpRequest httpRequest) {
        if (this.token == null) {
            String string = "";
            try {
                string = URLEncoder.encode(this.consumerKey, "UTF-8") + ":" + URLEncoder.encode(this.consumerSecret, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return "Basic " + BASE64Encoder.encode(string.getBytes());
        }
        return this.token.generateAuthorizationHeader();
    }

    public boolean isEnabled() {
        return this.token != null;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof OAuth2Authorization)) {
            return false;
        }
        OAuth2Authorization oAuth2Authorization = (OAuth2Authorization)object;
        if (this.consumerKey != null ? !this.consumerKey.equals(oAuth2Authorization.consumerKey) : oAuth2Authorization.consumerKey != null) {
            return false;
        }
        if (this.consumerSecret != null ? !this.consumerSecret.equals(oAuth2Authorization.consumerSecret) : oAuth2Authorization.consumerSecret != null) {
            return false;
        }
        return !(this.token != null ? !this.token.equals(oAuth2Authorization.token) : oAuth2Authorization.token != null);
    }

    public int hashCode() {
        int n2 = this.consumerKey != null ? this.consumerKey.hashCode() : 0;
        n2 = 31 * n2 + (this.consumerSecret != null ? this.consumerSecret.hashCode() : 0);
        n2 = 31 * n2 + (this.token != null ? this.token.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "OAuth2Authorization{consumerKey='" + this.consumerKey + '\'' + ", consumerSecret='******************************************'" + ", token=" + (this.token == null ? "null" : this.token.toString()) + '}';
    }
}

